IF  EXISTS (SELECT *
FROM SYS.OBJECTS
WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[EST_NF_SAI_RC_VD_CONV]') AND TYPE IN (N'U'))
BEGIN
	RETURN;
END
ELSE
BEGIN

	CREATE TABLE [dbo].[EST_NF_SAI_RC_VD_CONV](
		[CD_EMP] [int] NOT NULL CONSTRAINT [DF_EST_NF_SAI_RC_VD_CONV_CD_EMP]  DEFAULT ((0)),
		[CD_FILIAL] [int] NOT NULL CONSTRAINT [DF_EST_NF_SAI_RC_VD_CONV_CD_FILIAL]  DEFAULT ((0)),
		[CD_NF] [int] NOT NULL CONSTRAINT [DF_EST_NF_SAI_RC_VD_CONV_CD_NF]  DEFAULT ((0)),
		[CD_CTR] [int] NOT NULL CONSTRAINT [DF_EST_NF_SAI_RC_VD_CONV_CD_CTR]  DEFAULT ((0)),
	 CONSTRAINT [PK_EST_NF_SAI_RC_VD_CONV] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC,
		[CD_CTR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]



	ALTER TABLE [dbo].[EST_NF_SAI_RC_VD_CONV]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_RC_VD_CONV_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
	REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])


	ALTER TABLE [dbo].[EST_NF_SAI_RC_VD_CONV] CHECK CONSTRAINT [FK_EST_NF_SAI_RC_VD_CONV_EST_NF_SAI]


	ALTER TABLE [dbo].[EST_NF_SAI_RC_VD_CONV]  WITH NOCHECK ADD  CONSTRAINT [FK_EST_NF_SAI_RC_VD_CONV_RC_VD_CONV] FOREIGN KEY([CD_EMP], [CD_CTR])
	REFERENCES [dbo].[RC_VD_CONV] ([CD_EMP], [CD_CTR])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_NF_SAI_RC_VD_CONV] CHECK CONSTRAINT [FK_EST_NF_SAI_RC_VD_CONV_RC_VD_CONV]

END
